/*
 * 作成日: 2008/08/05
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.util;

import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.ui.internal.Column;


public class PropertyNameUtil {
	
	/**
	 * Entity + "Id" というプロパティからEntity名を取得する 例 hogeId → Hoge
	 * 
	 * @return
	 */
	public static String getEntityFromIdName(String str) {
		// 大文字、小文字の両方に対応する
		String wk = str.toUpperCase();
		int pos = wk.lastIndexOf("_ID");
		if (pos > 0) {
			return getEntityName(str.substring(0, pos));
		} else {
			return str;
		}
	}
	
	/**
	 * 頭大文字で_の後は大文字にする
	 * 
	 * @param strSrc
	 * @return
	 */
	public static String getEntityName(String strSrc) {
		strSrc = strSrc.toLowerCase(); // 一度全部小文字
		int nLen = strSrc.length();
		StringBuffer sb = new StringBuffer(nLen * 2);
		for (int i = 0; i < nLen; i++) {
			char c = strSrc.charAt(i);
			
			if (i == 0) {
				String s = new String(new char[] {c});
				sb.append(s.toUpperCase());
				
			} else {
				switch (c) {
					case '_':
						if (i < nLen - 1) {
							char next = strSrc.charAt(++i);
							String s = new String(new char[] {next});
							sb.append(s.toUpperCase());
						}
						break;
					default:

						sb.append(c);
						break;
				}
			}
		}
		return sb.toString();
	}
	
	/**
	 * 頭文字が小文字で_の後は大文字にする
	 * 
	 * @param strSrc
	 * @return
	 */
	public static String getPropertyName(String strSrc) {
		strSrc = strSrc.toLowerCase(); // 一度全部小文字
		int nLen = strSrc.length();
		StringBuffer sb = new StringBuffer(nLen * 2);
		for (int i = 0; i < nLen; i++) {
			char c = strSrc.charAt(i);
			switch (c) {
				case '_':
					if (i < nLen - 1) {
						char next = strSrc.charAt(++i);
						String s = new String(new char[] {next});
						sb.append(s.toUpperCase());
					}
					break;
				default:
					sb.append(c);
					break;
			}
		}
		return sb.toString();
	}
	
	public static String getProperty(Column col, boolean underLineCut) {
		TableColumn tCol = col.getColumn();
		if (!underLineCut) {
			return tCol.getColumnName().toLowerCase();
		} else {
			return PropertyNameUtil.getPropertyName(tCol.getColumnName());
		}
	}
	
	public static String getProperty(TableColumn tCol, boolean underLineCut) {
		if (!underLineCut) {
			return tCol.getColumnName().toLowerCase();
		} else {
			return PropertyNameUtil.getPropertyName(tCol.getColumnName());
		}
	}
	
	public static String getFieldName(String propertyName) {
		StringBuffer sb = new StringBuffer();
		sb.append(propertyName.substring(0, 1).toLowerCase());
		// 2文字から小文字化は行わない
		sb.append(propertyName.substring(1, propertyName.length()));
		return sb.toString();
	}
	

}
